'
' Wysokopoziomowe klasy automatu gastronomicznego s podklasami tej klasy abstrakcyjnej.
'
Public MustInherit Class AbstractFoodProcessorProgram

    Private myEnvironment As FoodProcessorEnvironmentIF
    '
    ' rodowisko automatu gastronomicznego przekazuje referencj do samego siebie
    ' na wejciu tej metody. Dziki temu egzemplarze podklas tej klasy mog
    ' wywoywa metody obiektu rodowiska operacyjnego automatu gastronomicznego,
    ' ktrego klasa implementuje interfejs FoodProcessorEnvironmentIF.
    '
    Public Property Environment() As FoodProcessorEnvironmentIF
        Get
            Return myEnvironment
        End Get
        Set(ByVal value As FoodProcessorEnvironmentIF)
            myEnvironment = Value
        End Set
    End Property

    '
    ' Nazwa danego obiektu programu pracy automatu gastronomicznego.
    '
    Public MustOverride ReadOnly Property Name() As String

    '
    ' Wywoanie tej metody powoduje, e program pracy automatu
    ' gastronomicznego rozpoczyna wykonywanie swoich czynnoci.
    '
    Public MustOverride Sub Start()

    '...

End Class 'AbstractFoodProcessorProgram
